# delimit ; 
clear; 
*clear _all;
clear matrix;
set mem 500m;	
set more 1 ;  
drop _all;
program drop _all;

*Impute medicaid payments from MCBS;
*do C:\Dropbox\hrs\wealthcouples\impute_Medicaid.do;
*do C:\Users\ebf26\Dropbox\hrs\wealthcouples\impute_Medicaid.do;

capture log close;
*log using C:\Dropbox\hrs\wealthcouples\dataprep_couples1.log,replace;
log using C:\Users\ebf26\Dropbox\hrs\wealthcouples\dataprep_couples1.log,replace;

*use C:\Dropbox\hrs\wealthcouples\dataprep0;
*use C:\Dropbox\hrs\wealthcouples\dataprep0_impute;
use C:\Users\ebf26\Dropbox\hrs\wealthcouples\dataprep0_impute;


************************************************************;
*********** SET PREFERENCES HERE ***************************;
************************************************************;

*gen useRAND=0;
gen useass=2; * 1--> assets, 0--> (initial?) income, 2--> average income ;
gen keepworker=0;
gen keepattrit=1; * keep people who are in the sample for only some of the waves;
gen keep_age_diff=0;
* FIXED EFFECTS OR OLS;
gen FE=1;
* make the permanent income measure the percentile (adist) -->USElevel=0; 
* or log level (firstass) -> USElevel=1;
gen USElevel=0;
* decide whether moments should be cohort-quantile-specific or just quantile specific;
gen BYcohort=0;
* topcode assets;
gen maxass=10000000;
gen mar_stat_drop=1; * 1=> drop non-stable marital status, 0 => keep non-stable marital status;
gen couples=1; * 1=> keep couples, 0=> keep only singles ;
gen includeestate=1;  * add estate values to asset values;

************************************************************;
* what the "dumpthis" variables mean;
* dumpthis: household splits up, multiple people with same HHID and same sex (usually from new partnering--will usually have different subhh);
* dumpthis0: separated or partnered;
* dumpthis1: divorce;
* dumpthis2: "died", then cam back to life;
* dumpthis3: individuals within the household disagree on mstat;
* dumpthis4: individual is missing (marstat==0);
************************do the drops ****************;



*****************************************************************************;
drop if hrscoh~=11 & hrscoh~=12; * KEEP ONLY THE AHEAD COHORT;

sum penwDC;

gen counter1=1;
replace counter1=counter1[_n-1]+1 if HHID==HHID[_n-1];
egen count1=sum(counter1) if counter1==1;
sum count*;


*****************************************************************************;

gen counter2=1;
replace counter2=counter2[_n-1]+1 if HHID==HHID[_n-1];
egen count2=sum(counter2) if counter2==1;
sum count*;

***************WE LOSE OBSERVATIONS IN SEVERAL STAGES;***********************;
sum assets mar_stat if wave==3;
sum assets mar_stat if wave==4;

drop if num~=0 & mar_stat_drop==1;  * drop if we want to get rid of unknown or changing mariatal status;

drop num dumpthis;
drop if num0~=0 & mar_stat_drop==1;  * drop if we want to get rid of unknown or changing mariatal status;
sum num0;
drop num0 dumpthis0;

sum penwDC;

drop if num1~=0 & mar_stat_drop==1;  * drop if we want to get rid of unknown or changing mariatal status;
sum num1;
drop num1 dumpthis1;

*******************************************************************************;
drop if num2~=0 & mar_stat_drop==1;  * drop if we want to get rid of unknown or changing mariatal status;
sum num2;
drop num2 dumpthis2;





drop if num3~=0 & mar_stat_drop==1;  * drop if we want to get rid of unknown or changing mariatal status;
sum num3;
drop num3 dumpthis3;

*******************************************************************************;

tab manmarstat womanmarstat;

gen dumpthis=0;
replace dumpthis=1 if manmarstat==9 & (womanmarstat==5|womanmarstat==8);
replace dumpthis=1 if womanmarstat==9 & (manmarstat==5|manmarstat==8);
egen num=sum(dumpthis), by (indnum);
drop if num~=0; * drop if we want to get rid of unknown or changing mariatal status;
drop num dumpthis;

drop if (firstman==.|firstwoman==.) & mar_stat_drop==1;
drop if (firstman==1 & firstwoman==1) & couples==0;


gen counter3=1;
replace counter3=counter3[_n-1]+1 if HHID==HHID[_n-1];
egen count3=sum(counter3) if counter3==1;
sum count*;




**********************drop workers ******************************;
gen onemPN=100-PN;
if keepworker==0{;
sort HHID wave onemPN;
order HHID wave PN;
gen _lfpr=.;
replace _lfpr=lfpr[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1];
sort HHID wave PN;
sum lfpr _lfpr married;

gen dumpworker=0;
*replace dumpworker=1 if lfpr==1|_lfpr==1|(laby>3000 & laby~=.); * drop workers here;
replace dumpworker=1  if (laby>3000 & laby~=.);
egen num5=sum(dumpworker), by (HHID);
tab num5;
drop if num5~=0;
drop dumpworker num5;
};

gen counter4=1;
replace counter4=counter4[_n-1]+1 if HHID==HHID[_n-1];
egen count4=sum(counter4) if counter4==1;
sum count*;


*drop if cohort==.;

* drop missings?;
drop if num4~=0 & mar_stat_drop==1 & keepattrit==0;  * this really just gets rid of attriters, also drops unknown or changing mariatal status;
sum num4;
drop num4 dumpthis4;

sum assets mar_stat if wave==3;
sum assets mar_stat if wave==4;


* fix up married & dead variables;
replace married=1 if male==1 & manmarstat==1 & married==.;
replace married=0 if male==1 & (manmarstat~=1 & manmarstat~=0) & married==.;
replace married=1 if male==0 & womanmarstat==1 & married==.;
replace married=0 if male==0 & (womanmarstat~=1 & womanmarstat~=0) & married==.;
sum dead;
replace dead=1 if male==1 & manmarstat==9;
replace dead=0 if male==1 & (manmarstat~=9 & manmarstat~=0);
replace dead=1 if male==0 & womanmarstat==9;
replace dead=0 if male==0 & (womanmarstat~=9 & womanmarstat~=0);
replace died=dead; * better yet, track down died and just get rid of it;
sum dead;

***********;
replace mandead=1 if manmarstat==9 & male==1;
sort HHID wave male;
replace mandead=mandead[_n+1] if HHID==HHID[_n+1] & wave==wave[_n+1];
replace womandead=1 if womanmarstat==9 & male==0;
sort HHID wave male;
replace womandead=womandead[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1];
***********;



*gen _nursing = .;
*gen _drtimes = .;
*gen _hosp = .;

************add value of DC pension wealth to assets ********;
replace penwDC=0 if penwDC==.;
sum assets penwDC;
replace assets=assets+penwDC;
sum assets penwDC;


* check that everyone has their spouse's household weight, assets, death expenses, health care utilization;
sort HHID wave PN;
replace wgthh=wgthh[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & wgthh==. & wgthh[_n-1]~=.;
replace assets=assets[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & assets==. & assets[_n-1]~=.;
replace house=house[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & house==. & house[_n-1]~=.;
replace re=re[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & re==. & re[_n-1]~=.;
replace wheels=wheels[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & wheels==. & wheels[_n-1]~=.;
replace liquid=liquid[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & liquid==. & liquid[_n-1]~=.;
replace IRA=IRA[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & IRA==. & IRA[_n-1]~=.;
replace stock=stock[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & stock==. & stock[_n-1]~=.;
replace bus=bus[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & bus==. & bus[_n-1]~=.;
replace bonds=bonds[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & bonds==. & bonds[_n-1]~=.;
replace exasset=exasset[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & exasset==. & exasset[_n-1]~=.;
replace debts=debts[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & debts==. & debts[_n-1]~=.;
replace remort=remort[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & remort==. & remort[_n-1]~=.;
replace mort=mort[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & mort==. & mort[_n-1]~=.;

replace estate=estate[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & estate==. & estate[_n-1]~=.;
replace amspouse=amspouse[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & amspouse==. & amspouse[_n-1]~=.;

replace deathex=deathex[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & deathex==. & deathex[_n-1]~=.;
replace deathins=deathins[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & deathins==. & deathins[_n-1]~=.;
replace inspay=inspay[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & inspay==. & inspay[_n-1]~=.;

*replace _nursing = nursing[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1];
*replace _drtimes = drtimes[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1];
*replace _hosp = hosp[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1];

sort HHID wave onemPN;
replace wgthh=wgthh[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & wgthh==. & wgthh[_n-1]~=.;
replace assets=assets[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & assets==. & assets[_n-1]~=.;
replace house=house[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & house==. & house[_n-1]~=.;
replace re=re[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & re==. & re[_n-1]~=.;
replace wheels=wheels[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & wheels==. & wheels[_n-1]~=.;
replace liquid=liquid[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & liquid==. & liquid[_n-1]~=.;
replace IRA=IRA[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & IRA==. & IRA[_n-1]~=.;
replace stock=stock[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & stock==. & stock[_n-1]~=.;
replace bus=bus[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & bus==. & bus[_n-1]~=.;
replace bonds=bonds[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & bonds==. & bonds[_n-1]~=.;
replace exasset=exasset[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & exasset==. & exasset[_n-1]~=.;
replace debts=debts[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & debts==. & debts[_n-1]~=.;
replace remort=remort[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & remort==. & remort[_n-1]~=.;
replace mort=mort[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & mort==. & mort[_n-1]~=.;

replace estate=estate[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & estate==. & estate[_n-1]~=.;
replace amspouse=amspouse[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & amspouse==. & amspouse[_n-1]~=.;

replace deathex=deathex[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & deathex==. & deathex[_n-1]~=.;
replace deathins=deathins[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & deathins==. & deathins[_n-1]~=.;
replace inspay=inspay[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & inspay==. & inspay[_n-1]~=.;

*replace _nursing = nursing[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1];
*replace _drtimes = drtimes[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1];
*replace _hosp = hosp[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1];

*********************************************************;
* GENERATE INITIAL WEALTH AND INCOME VARIABLES           ;
*********************************************************;

* WEALTH ;
* get individual's original asset level;
sort indnum wave;
gen la=.;
replace la=assets[_n-1] if indnum==indnum[_n-1];
gen lla=.;
replace lla=la[_n-1] if indnum==indnum[_n-1];
gen llla=.;
replace llla=lla[_n-1] if indnum==indnum[_n-1];
gen lllla=.;
replace lllla=llla[_n-1] if indnum==indnum[_n-1];
gen llllla=.;
replace llllla=lllla[_n-1] if indnum==indnum[_n-1];
gen lllllla=.;
replace lllllla=llllla[_n-1] if indnum==indnum[_n-1];
gen llllllla=.;
replace llllllla=lllllla[_n-1] if indnum==indnum[_n-1];
gen lllllllla=.;
replace lllllllla=llllllla[_n-1] if indnum==indnum[_n-1];


gen firstass=.;
replace firstass=assets if wave==firstwave;
replace firstass=la if wave==firstwave+1;
replace firstass=lla if wave==firstwave+2;
replace firstass=llla if wave==firstwave+3;
replace firstass=lllla if wave==firstwave+4;
replace firstass=llllla if wave==firstwave+5;
replace firstass=lllllla if wave==firstwave+6;
replace firstass=llllllla if wave==firstwave+7;
replace firstass=lllllllla if wave==firstwave+8;


sort wave;
by wave: summ assets la lla llla lllla firstass firstman firstwoman;

* INCOME;
*******ERIC'S CODING**********************************;
* note:faminc laby + selfy+ capy + peny + othy + socy ;
* laby=labor inc                                      ;
* selfy = self-employment income                      ;
* capy=capital inc                                    ;
* peny=pension inc (from a firm, va),+annuties        ;
* othy= ssi, unemployment, workers comp               ;
* socy=social security/di income                      ;
* RAND CODING ****************************************;
* note:faminc laby + selfy+ capy + peny + othy + socy ;
* laby=labor inc                                      ;
* capy=capital inc AND SELF EMPLOYEMENT INCOME        ;
* peny=pension inc (ONLY FROM FIRMS, NOT THE VA),+annuties;
* socy=social security ONLY (NO DI INCOME)            ;
* SSDIY= SSI and DI                                   ;
* UNEMPY=unemployment and workers compensation        ;
* OTHgovY= other government, such as veterans benefits, welfare, food stamps;
* OTHincY=inheritance, lump sum pension, alimony      ;
******************************************************;
*NOTE: FAMINC IS RECREATED IN THE IMPUTATION FILE-CHANGES MUST BE MADE IN BOTH FILES*;
* USE ANNUITIZED INCOME AS THE BENCHMARK--does that make sense?:
* think about how to model the consumption floor-- for example SSI SHOULD NOT be in the income measure;
if useRAND==0{;
gen anninc= socy+peny; * annuitized income=peny+othy;
gen hhinc=anninc+laby+selfy; * include labor income;
replace faminc=hhinc+capy +othy; * include capital income, welfare, SSI;
};



sum socy peny OTHgovY VAinc;
sort male HHID wave;
replace VAinc=VAinc[_n-1] if HHID==HHID[_n-1] & PN==PN[_n-1] & VAinc==. & socy~=. & dead~=1;
replace VAinc=0 if VAinc==. & socy~=.;
order male HHID PN wave VAinc socy;

if useRAND==1{;
gen anninc=socy+peny +VAinc; * Note: took out SSDIY and welfare, because we model the consumption floor from SSI/welfare payments explicitly, but we want veteran's benefits in there;
* gen anninc=socy+peny+SSDIY+UNEMPY+OTHgovY; * Old version;
*replace anninc=anninc+OTHincY;
gen hhinc=anninc+laby; *add in SSDIY here ;
replace faminc=hhinc+capy +UNEMPY +SSDIY; * include capital income, welfare, SSI, SSDI;
};


*tab wave;

sum socy peny laby capy UNEMPY OTHgovY SSDIY;
*exit;


sort wave;
by wave: sum laby capy peny othy;


gen lowlev=1000;
replace hhinc=lowlev if hhinc<lowlev & hhinc~=.;
replace faminc=lowlev if faminc<lowlev & faminc~=.;
replace anninc=lowlev if anninc<lowlev & anninc~=.;
replace socy=lowlev if socy<lowlev & socy~=.;

* check that everyone has their spouses income;
sort HHID wave PN;
replace anninc=anninc[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & anninc==. & anninc[_n-1]~=.;
replace hhinc = hhinc[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & hhinc==.;
replace SSDIY = SSDIY[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & SSDIY==.;
sort HHID wave onemPN;
replace anninc= anninc[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & anninc==. & anninc[_n-1]~=.;
replace hhinc = hhinc[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & hhinc==.;
replace SSDIY = SSDIY[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & SSDIY==.;

sort HHID wave PN;
replace socy=socy[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & socy==. & socy[_n-1]~=.;
sort HHID wave onemPN;
replace socy= socy[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & socy==. & socy[_n-1]~=.;

* decide whether anninc or socy defines the "right" income measure;
gen incmeasure=anninc;


sort HHID realyear male;
*save C:\Dropbox\hrs\wealthcouples\dataprep0x, replace;
save C:\Users\ebf26\Dropbox\hrs\wealthcouples\dataprep0x, replace;


*************to dos ******;
* 1) tablulate age differences between husbands and wives in wave 3;


sort  HHID wave male;
gen age_wife = age[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1];
gen age_diff=age_wife-age;
tab age_diff if wave==3;


* 2) calculate imputed age of wives= husbands age-2;

gen age_wifex = age-2 if HHID==HHID[_n-1] & wave==wave[_n-1];
order HHID wave male married age age_wife age_wifex;

* 3) drop if age difference is too big;
gen outsample=0;
replace outsample=1 if abs(age_wife-age_wifex)>7 & abs(age_wife-age_wifex)~=. & wave==3;
by HHID: egen num6=sum(outsample);

drop if num6>0 & keep_age_diff==0;
drop num6 outsample;



gen hhage=.;
replace hhage= age if HHID==HHID[_n-1] & wave==wave[_n-1];
replace hhage= hhage[_n+1] if HHID==HHID[_n+1] & wave==wave[_n+1];
replace hhage= age+2 if HHID==HHID[_n+1] & wave~=wave[_n+1] & male==0;
replace hhage= age+2 if HHID==HHID[_n-1] & PN==PN[_n-1] & wave~=wave[_n-1] & male==0; //to fill in wave 10;
replace hhage= age if HHID==HHID[_n+1] & PN==PN[_n+1] & male==1;
replace hhage= age if HHID==HHID[_n-1] & PN==PN[_n-1] & male==1; //to fill in wave 10;


* Drop if no domestic partner in sample but married in some wave;

gen couple=0;
replace couple=1 if HHID==HHID[_n-1] & wave==wave[_n-1];
replace couple=1 if HHID==HHID[_n+1] & wave==wave[_n+1];
drop if couple==0 & firsthh==3;

sum assets mar_stat if wave==3;
sum assets mar_stat if wave==4;


*move last cost variables to first wave of death;
gen firstdead=0;
replace firstdead=1 if couple==0 & mandead==1 & male==1 & mandead[_n-1]==0;
replace firstdead=1 if couple==0 & womandead==1 & male==0 & womandead[_n-1]==0;
replace firstdead=1 if couple==1 & mandead==1 & male==1 & mandead[_n-2]==0;
replace firstdead=1 if couple==1 & womandead==1 & male==0 & womandead[_n-2]==0;



sum medcost* iprem*;



forval i=1/4 {;
foreach x in medcost medcost_b medcost_bmedicaid rmedcost oop drugc iprem iprem_b roopd nursing medicaid_pay {;
gen flag=1 if couple==0 & `x'==. & firstdead==1 & HHID==HHID[_n+`i'] & `x'[_n+`i']~=.;
replace `x'=`x'[_n+`i'] if flag==1;
replace `x'=. if flag[_n-`i']==1;
drop flag;
};
};
forval i=2(2)6 {;
foreach x in medcost medcost_b medcost_bmedicaid rmedcost oop drugc iprem iprem_b roopd nursing medicaid_pay {;
gen flag=1 if couple==1 & firstdead==1 & `x'==. &`x'[_n+`i']~=. & HHID==HHID[_n+`i'];
replace `x'=`x'[_n+`i'] if flag==1;
replace `x'=. if flag[_n-`i']==1;
drop flag;
};
};


gen _medicaid_pay=.;
*reset _variables;
foreach x in medcost medcost_b medcost_bmedicaid rmedcost oop drugc iprem iprem_b roopd nursing drtimes hosp medicaid medicaid_pay{;
replace _`x'=0;
replace _`x'=`x'[_n+1] if male==0 & couple==1;
replace _`x'=`x'[_n-1] if male==1 & couple==1;
};

sum medcost* iprem*;
sort died;
by died: sum medcost* iprem*;

*use this in constructing hhmedcost_b, "annualize" correct part b payments for dead households here as we replace all values;
*medcost is already annualized even for those who die (dataprep0);
replace medcost_b=medcost+ptBprem if medicaid==0 & (medhmo==0|medhmo==.) & medcare==1;
replace medcost_b=medcost if medcost_b==. & dead==0;
replace iprem_b=iprem+ptBprem if medicaid==0 & (medhmo==0|medhmo==.) & medcare==1;
replace iprem_b=iprem if iprem_b==. & dead==0;
replace medcost_bmedicaid=medcost+ptBprem if (medhmo==0|medhmo==.) & medcare==1;
replace medcost_bmedicaid=medcost if medcost_bmedicaid==. & dead==0;

*eliminate ptBprem/2 replace with ptBprem in first of each pair to correctly "annualize";
sort HHID PN wave;
replace medcost_b=medcost+ptBprem if died==1 & (medicaid==0|(medicaid==. & medicaid[_n-1]==0)) & (medhmo[_n-1]==0|medhmo[_n-1]==.) & medcare[_n-1]==1;
replace medcost_b=medcost if died==1 & medcost_b==.;
replace iprem_b=iprem+ptBprem if died==1 & (medicaid==0|(medicaid==. & medicaid[_n-1]==0)) & (medhmo[_n-1]==0|medhmo[_n-1]==.) & medcare[_n-1]==1;
replace iprem_b=iprem if died==1 & iprem_b==.;
replace medcost_bmedicaid=medcost+ptBprem if died==1 & (medhmo[_n-1]==0|medhmo[_n-1]==.) & medcare[_n-1]==1;
replace medcost_bmedicaid=medcost if died==1 & medcost_bmedicaid==.;

sum medcost* iprem*;


sort HHID wave male;
replace _ptBprem=ptBprem[_n-1] if HHID==HHID[_n-1] & sub==sub[_n-1] & wave==wave[_n-1];
replace _medcost_b=medcost_b[_n-1] if  HHID==HHID[_n-1] & sub==sub[_n-1] & wave==wave[_n-1];
replace _iprem_b=iprem_b[_n-1] if  HHID==HHID[_n-1] & sub==sub[_n-1] & wave==wave[_n-1];
replace _medicaid_pay=medicaid_pay[_n-1] if  HHID==HHID[_n-1] & sub==sub[_n-1] & wave==wave[_n-1];
replace _medcost_bmedicaid=medcost_bmedicaid[_n-1] if  HHID==HHID[_n-1] & sub==sub[_n-1] & wave==wave[_n-1];
replace _ptBprem=ptBprem[_n+1] if HHID==HHID[_n+1] & sub==sub[_n+1] & wave==wave[_n+1];
replace _medcost_b=medcost_b[_n+1] if  HHID==HHID[_n+1] & sub==sub[_n+1] & wave==wave[_n+1];
replace _iprem_b=iprem_b[_n+1] if  HHID==HHID[_n+1] & sub==sub[_n+1] & wave==wave[_n+1];
replace _medicaid_pay=medicaid_pay[_n+1] if  HHID==HHID[_n+1] & sub==sub[_n+1] & wave==wave[_n+1];
replace _medcost_bmedicaid=medcost_bmedicaid[_n+1] if  HHID==HHID[_n+1] & sub==sub[_n+1] & wave==wave[_n+1];

* Find the additional (over and above medcost_b) payments for medicare part b paid by medicaid.;
gen partb_extra=medcost_bmedicaid-medcost_b;
gen _partb_extra=_medcost_bmedicaid-_medcost_b;
*Sum these into medicaid_pay, the hypothethical oop costs a household could have to pay;
sum *partb* *medicaid_pay*;
replace medicaid_pay=medicaid_pay+partb_extra; 
replace _medicaid_pay=_medicaid_pay+_partb_extra;
sum *partb* *medicaid_pay*;

drop partb_extra _partb_extra;

gen mandied=0;
replace mandied=1 if firstdead==1 & male==1;
gen womandied=0;
replace womandied=1 if firstdead==1 & male==0;

gen manheal=heal if male==1;
gen womanheal=heal if male==0;
replace manheal=manheal[_n+1] if HHID==HHID[_n+1] & wave==wave[_n+1];
replace womanheal=womanheal[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1];

gen mannursing=nursing if male==1;
gen womannursing=nursing if male==0;
replace mannursing=mannursing[_n+1] if HHID==HHID[_n+1] & wave==wave[_n+1];
replace womannursing=womannursing[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1];

gen manadl=radl if male==1;
gen womanadl=radl if male==0;
replace manadl=manadl[_n+1] if HHID==HHID[_n+1] & wave==wave[_n+1];
replace womanadl=womanadl[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1];

gen rINC=rSOCY+rPENY+rSSDIY;
gen _rINC=_rSOCY+_rPENY+_rSSDIY;
* in RANDCODE.do all income measures are summed over husbands and wives;
replace rINC=rINC-_rINC;
replace rSOCY=rSOCY-_rSOCY;
replace rPENY=rPENY-_rPENY;
replace rSSDIY=rSSDIY-_rSSDIY;

gen manINC=rINC if male==1;
gen womanINC=rINC if male==0;
sort HHID PN wave;
replace womanINC=_rINC if womanINC==. & male==1;
replace manINC=manINC[_n+1] if HHID==HHID[_n+1] & wave==wave[_n+1];
replace womanINC=womanINC[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1];

* 4) create a dataset saving all results;
sort  HHID wave male;
*save C:\Dropbox\hrs\wealthcouples\dataprep1x, replace;
save C:\Users\ebf26\Dropbox\hrs\wealthcouples\dataprep1x, replace;


* 5) drop wives in households ;
drop if HHID==HHID[_n+1] & wave==wave[_n+1] & mandead==0 & womandead==0;

* 6) Run fe regressions, create PI ranking for each household;
tab manmarstat womanmarstat;




gen linc= log(incmeasure);
gen hhage2=hhage^2;
gen hhage3=hhage^3;

gen dkmarstat=1 if womanmarstat==0 & manmarstat==0;
gen single_m= 0;
replace single_m= 1 if manmarstat~=1 & male==1 & dkmarstat~=1; * note that this will include dead people;

gen single_w= 0;
replace single_w=1 if manmarstat~=1 & male==0 & dkmarstat~=1; * note that this will include dead people;


*gen hhead=1 if male==1 & mandead==0;
*replace hhead=1 if male==0 & HHID==HHID[_n+1] & wave==wave[_n+1] & womandead==0 & mandead==1;
*replace hhead=1 if male==0 & womandead==0 & womanmarstat~=0; //incorrect?

gen hhstatus=1 if single_w==1;
replace hhstatus=2 if single_m==1;
replace hhstatus=3 if manmarstat==1;

*assign man hhstatus and firstdead in coupled households;
replace hhstatus=hhstatus[_n-1] if womandead==0 & mandead==1 & HHID==HHID[_n-1] & wave==wave[_n-1];
replace womandied=womandied[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1];

gen hhdead=0;
replace hhdead=1 if mandead==1 & womandead==1;
replace hhdead=1 if mandead==1 & hhstatus==2;
replace hhdead=1 if womandead==1 & hhstatus==1;

replace hhstatus=0 if hhdead==1;


gen _firsthh96=3 if hhstatus==3 & wave==3;
replace _firsthh96=2 if hhstatus==2 & wave==3;
replace _firsthh96=1 if hhstatus==1 & wave==3;

by HHID: egen firsthh96=max(_firsthh96);
drop _firsthh96;
* Drop all women from household that started married so that household-wave is unit of observation;
drop if male==0 & HHID==HHID[_n+1] & wave==wave[_n+1];

sum heal assets mar_stat _heal  if wave==3;
sum heal assets mar_stat _heal  if wave==4;



foreach x in medcost medcost_b rmedcost oop drugc iprem iprem_b roopd nursing drtimes hosp medicaid medicaid_pay{;
gen hh`x'=.;
replace hh`x'=`x' if firsthh==2|firsthh==1;
replace hh`x'=`x'+_`x' if hhstatus==3;
replace hh`x'=`x' if hhstatus==2 & womandied==0 & firsthh==3;
replace hh`x'=`x'+_`x' if hhstatus==2 & womandied==1 & firsthh==3;
replace hh`x'=_`x' if hhstatus==1 & womandied==0 & firsthh==3;
replace hh`x'=`x'+_`x' if hhstatus==1 & mandied==1 & firsthh==3;
replace hh`x'=`x'+_`x' if firsthh==3 & (hhstatus==0 & hhstatus[_n-1]==3)|(hhstatus==0 & hhstatus[_n-1]==.);
replace hh`x'=`x' if hhstatus==0 & hhstatus[_n-1]==2 & firsthh==3;
replace hh`x'=_`x' if hhstatus==0 & hhstatus[_n-1]==1 & firsthh==3;
};
replace hhmedicaid=1 if hhmedicaid==2;

drop single_m single_w;
gen single_m=0;
replace single_m=1 if hhstatus==2;
gen single_w=0;
replace single_w=1 if hhstatus==1;


******;
*sort HHID PN wave;
*replace linc=linc[_n-1] if linc==. & linc[_n-1]~=. & linc[_n+1]==. & linc[_n+2]==. & 
*wave==3 & wave[_n-1]==2 & HHID==HHID[_n-1] & HHID[_n+1]==HHID & HHID[_n+1]==HHID & HHID[_n+2]==HHID
*& wave[_n+1]==4 & wave[_n+2]==5;
replace linc=. if wave==2;
******;
* gen wave 2 weight here;
gen wgt`firstwave'=wgthh if wave==firstwave;

sort HHID PN wave;
replace wgt`firstwave'=wgt`firstwave'[_n-1] if HHID==HHID[_n-1] & PN==PN[_n-1] & wave~=firstwave;

xtset HHID;

xtreg linc single_m single_w hhage single_m#c.hhage	single_w#c.hhage hhage2	hhage3 if hhdead==0 & hhstatus~=., fe;
order HHID wave male linc;
gen g_hat = _b[_cons]+_b[single_m]*single_m+_b[single_w]*single_w+_b[hhage]*hhage+_b[hhage2]*hhage2+_b[hhage3]*hhage3+_b[1.single_m#c.hhage]*1.single_m#c.hhage+_b[1.single_w#c.hhage]*1.single_w#c.hhage if hhdead==0 & hhstatus~=.;
gen err_pi=linc-g_hat;
by HHID: egen HHFE=mean(err_pi);


tempfile temp_file;
save `temp_file';
collapse HHFE, by(HHID);
sort HHID;
merge 1:m HHID using `temp_file';


cumul HHFE, gen(pi_perc);
cumul HHFE [w=wgt`firstwave'], gen(pi_perc_weighted) ;

sort HHID wave;
order HHID wave HHFE pi*;
replace pi_perc=pi_perc[_n-1] if HHID==HHID[_n-1];



gen pi_perc2= pi_perc*pi_perc;
gen pi_perc3= pi_perc^3;
gen pi_perc4= pi_perc^4;
gen pi_perc5= pi_perc^5;
reg err_pi pi_perc pi_perc2 pi_perc3 pi_perc4 pi_perc5;

predict inc_pi;
gen linc_hat= g_hat + inc_pi;
sort HHID wave male;
reg linc linc_hat;

predict leftover, residual;


sum leftover;
xtset HHID wave;
reg leftover L.leftover;
reg leftover L3.leftover;
corr leftover L.leftover;
corr leftover L3.leftover;
*********************;

xtreg linc single_m single_w hhage single_m#c.hhage	single_w#c.hhage hhage2	hhage3 if hhdead==0 & hhstatus~=., fe;

gen ageshift= _b[_cons]+_b[hhage]*hhage+_b[hhage2]*hhage2+_b[hhage3]*hhage3; //cons here?
gen singmshift= _b[single_m]*single_m+_b[1.single_m#c.hhage]*1.single_m#c.hhage;
gen singmshift_all= _b[single_m]+_b[1.single_m#c.hhage]*hhage;
gen singfshift= _b[single_w]*single_w+_b[1.single_w#c.hhage]*1.single_w#c.hhage;
gen singfshift_all= _b[single_w]+_b[1.single_w#c.hhage]*hhage;

reg err_pi pi_perc pi_perc2 pi_perc3 pi_perc4 pi_perc5;

gen bPI0 =_b[_cons];
gen bPI1 =_b[pi_perc];
gen bPI2=_b[pi_perc2];
gen bPI3=_b[pi_perc3];
gen bPI4=_b[pi_perc4];
gen bPI5=_b[pi_perc5];
* need to export these 6 varaibles into an ASCII files;
*tempfile temp;
*save `temp';
*keep bPI*;
*keep if _n==1;
*outfile using PIcoefs, replace;
*use `temp', clear;

gen PIshift=inc_pi; //?? or minus _b[_cons]?

* figure out variance of residual;
gen resres=err_pi-inc_pi;
egen sdres=sd(resres);
gen varc=(sdres*sdres)/2;
sum varc;
gen ageshiftvarc=ageshift+varc;

******************the code below generates alternative measures of "permanent income".  I do not think I am using any of this stuff anymore ;

* get individual's original income (or potentially asset) level;
sort indnum wave;
gen laginc=.;
replace laginc=incmeasure[_n-1] if indnum==indnum[_n-1];
gen llaginc=.;
replace llaginc=laginc[_n-1] if indnum==indnum[_n-1];
gen lllaginc=.;
replace lllaginc=llaginc[_n-1] if indnum==indnum[_n-1];
gen llllaginc=.;
replace llllaginc=lllaginc[_n-1] if indnum==indnum[_n-1];
gen lllllaginc=.;
replace lllllaginc=llllaginc[_n-1] if indnum==indnum[_n-1];
gen llllllaginc=.;
replace llllllaginc=lllllaginc[_n-1] if indnum==indnum[_n-1];
gen lllllllaginc=.;
replace lllllllaginc=llllllaginc[_n-1] if indnum==indnum[_n-1];
gen llllllllaginc=.;
replace llllllllaginc=lllllllaginc[_n-1] if indnum==indnum[_n-1];


gen firstinc=.;
replace firstinc=incmeasure if wave==2;
replace firstinc=laginc if wave==3;
replace firstinc=llaginc if wave==4;
replace firstinc=lllaginc if wave==5;
replace firstinc=llllaginc if wave==6;
replace firstinc=lllllaginc if wave==7;
replace firstinc=llllllaginc if wave==8;
replace firstinc=lllllllaginc if wave==9;
replace firstinc=llllllllaginc if wave==10;


******************************************************; 
*generate average income for the years we have income;
******************************************************;

gen avinc=(llllllllaginc+lllllllaginc+llllllaginc+lllllaginc+llllaginc+lllaginc+llaginc+laginc+incmeasure)/9;
replace avinc=(lllllllaginc+llllllaginc+lllllaginc+llllaginc+lllaginc+llaginc+laginc+incmeasure)/8 if avinc==.;
replace avinc=(llllllaginc+lllllaginc+llllaginc+lllaginc+llaginc+laginc+incmeasure)/7 if avinc==.;
replace avinc=(lllllaginc+llllaginc+lllaginc+llaginc+laginc+incmeasure)/6 if avinc==.;
replace avinc=(llllaginc+lllaginc+llaginc+laginc+incmeasure)/5 if avinc==.;
replace avinc=(lllaginc+llaginc+laginc+incmeasure)/4 if avinc==.;
replace avinc=(llaginc+laginc+incmeasure)/3 if avinc==.;
replace avinc=(laginc+incmeasure)/2 if avinc==.;
replace avinc=(incmeasure) if avinc==.;

* use last years avinc if avinc==.;
sort HHID PN realyear;
replace avinc= avinc[_n-1] if HHID==HHID[_n-1] & PN==PN[_n-1] & avinc==. & avinc[_n-1]~=.;
* use the males avinc measure;
sort HHID wave female;
replace avinc= avinc[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & avinc[_n-1]~=.;
sort HHID wave male;
replace avinc= avinc[_n-1] if HHID==HHID[_n-1] & wave==wave[_n-1] & avinc[_n-1]~=.;

*now get the final (hopefully wave 9) measure for all previous waves;
gen omrealyear=100-realyear;
sort HHID PN omrealyear;
replace avinc= avinc[_n-1] if HHID==HHID[_n-1] & avinc[_n-1]~=.;
sort HHID PN realyear;
replace avinc= avinc[_n-1] if HHID==HHID[_n-1] & avinc==.;
sort HHID PN omrealyear;
replace avinc= avinc[_n-1] if HHID==HHID[_n-1] & avinc[_n-1]~=.;

drop laginc ll*inc ;

if useass==0{;
drop firstass;
rename firstinc firstass;
};
if useass==2{;
drop firstass;
rename avinc firstass;
};

sort HHID realyear male;
*save C:\Dropbox\hrs\wealthcouples\dataprep0x, replace;
save C:\Users\ebf26\Dropbox\hrs\wealthcouples\dataprep0x, replace;


* make a dataset of married wives (to be merged back in later);
keep if HHID==HHID[_n+1] & realyear==realyear[_n+1];
sum died male married;
sort married;
by married: sum male;

sort cohort;
by cohort: sum male firstass;
sort cohort HHID realyear PN male firstass; 

order cohort HHID realyear PN male firstass; 
*save C:\Dropbox\hrs\wealthcouples\dataprep1, replace;
save C:\Users\ebf26\Dropbox\hrs\wealthcouples\dataprep1, replace;
drop _all;

*use C:\Dropbox\hrs\wealthcouples\dataprep0x;
use C:\Users\ebf26\Dropbox\hrs\wealthcouples\dataprep0x;

* now get rid of wives ;
sort HHID realyear male;
drop if HHID==HHID[_n+1] & realyear==realyear[_n+1];

sort cohort;
by cohort: sum male firstass;


sort married;
by married: sum male;

**********************************************************;
* DECIDE WHETHER TO USE INCOME OR ASSETS                  ;
**********************************************************;
**********************************************************;
* generate some asset dummies ****************************;
**********************************************************;
* this program generates quantiles of the wealth distribution, by age;
program define gendist;
        version 3.1;

gen a1=.2;
gen a2=.4;
gen a3=.6;
gen a4=.8;

gen aa=.;
gen ab=.;
gen ac=.;
gen ad=.;
gen ae=.;

gen ass1=0;
gen ass2=0;
gen ass3=0;
gen ass4=0;
gen ass5=0;

tab wave;

gen adist=pi_perc;
gen adist_weighted=pi_perc_weighted;

*sum adist*;
*exit;
*cumul firstass, gen(adist) ;
*cumul firstass [w=wgt`firstwave'], gen(adist_weighted) ;

    local i = 1 ;
    while `i' <=7 { ;	
sum firstass if cohort==`i';
	
cumul firstass if (cohort==`i'), gen(adist`i');
* IF USING INCOME, DO NOT MAKE MOMENTS COHORT-SPECIFIC;
replace adist`i'= adist if BYcohort==0; 

* assji=assets, quantile j, cohort i;

gen ass1`i'=0;
replace ass1`i'=1 if cohort==`i' & adist`i'<a1; 
gen ass2`i'=0;
replace ass2`i'=1 if cohort==`i' & adist`i'>=a1 & adist`i'<a2;
gen ass3`i'=0;
replace ass3`i'=1 if cohort==`i' & adist`i'>=a2 & adist`i'<a3;
gen ass4`i'=0;
replace ass4`i'=1 if cohort==`i' & adist`i'>=a3 & adist`i'<a4;
gen ass5`i'=0;
replace ass5`i'=1 if cohort==`i' & adist`i'>=a4;

sum firstass ass1`i' if cohort==`i';
 
	local i = `i'+1 } ;
sort cohort;
end;
set trace off ;
gendist;

sum adist firstass;

* merge in the wives;
sort HHID realyear male;
*append using  C:\Dropbox\hrs\wealthcouples\dataprep1;
append using  C:\Users\ebf26\Dropbox\hrs\wealthcouples\dataprep1;
sum died male married;

*this program fills in quantiles for married wives;
program define wifefill;
        version 3.1;
	sort HHID realyear female;
replace adist = adist[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & firstass==firstass[_n-1] & adist==.; 
sum firstass adist;
order HHID realyear PN female adist; 
    local i = 1 ;
    while `i' <=7 { ;
	sort HHID realyear female;
sum firstass if cohort==`i';
replace ass1`i' = ass1`i'[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & ass1`i'==. & cohort==`i'; 
replace ass2`i' = ass2`i'[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & ass2`i'==. & cohort==`i';; 
replace ass3`i' = ass3`i'[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & ass3`i'==. & cohort==`i';; 
replace ass4`i' = ass4`i'[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & ass4`i'==. & cohort==`i';; 
replace ass5`i' = ass5`i'[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & ass5`i'==. & cohort==`i';;

sort HHID realyear male;

replace ass1`i' = ass1`i'[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & ass1`i'==. & cohort==`i';; 
replace ass2`i' = ass2`i'[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & ass2`i'==. & cohort==`i';; 
replace ass3`i' = ass3`i'[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & ass3`i'==. & cohort==`i';; 
replace ass4`i' = ass4`i'[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & ass4`i'==. & cohort==`i';; 
replace ass5`i' = ass5`i'[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & ass5`i'==. & cohort==`i';;

replace ass1=ass1`i' if cohort==`i';
replace ass2=ass2`i' if cohort==`i';
replace ass3=ass3`i' if cohort==`i';
replace ass4=ass4`i' if cohort==`i';
replace ass5=ass5`i' if cohort==`i';

	local i = `i'+1 } ;

sort cohort;
end;
set trace off ;
wifefill;

* this uses the individual's agtual age rather than hhage.  age and hhage should always be the same for men, but not for women;
* below we use actual age;

rename age age1;
gen age2=age1*age1;
gen age3=age2*age1;
gen age4=age3*age1;
gen age5=age4*age1;
gen age6=age5*age1;

gen cohort1=0;
replace cohort1=1 if cohort==1;
gen cohort2=0;
replace cohort2=1 if cohort==2;
gen cohort3=0;
replace cohort3=1 if cohort==3;
gen cohort4=0;
replace cohort4=1 if cohort==4;
gen cohort5=0;
replace cohort5=1 if cohort==5;
gen cohort6=0;
replace cohort6=1 if cohort==6;
gen cohort7=0;
replace cohort7=1 if cohort==7;

gen lhhinc=ln(hhinc);
*gen linc=ln(faminc);
gen lanninc=ln(anninc);
gen lsocy=ln(socy);

* this makes more sense for income than wealth;
replace firstass= lowlev if firstass< lowlev;
gen lfirstass=ln(firstass);


gen PI=adist; 
sort HHID PN realyear;
replace PI= PI[_n-1] if HHID==HHID[_n-1];





replace PI=lfirstass if USElevel==1;
gen PIage=PI*age1;
gen PI2=PI*PI; gen PI3=PI2*PI;

if USElevel==0 {;
	gen Pip1=.2;
	gen Pip2=.4;
	gen Pip3=.6;
	gen Pip4=.8;
};
if USElevel==1 {;
	egen Pip1=mean(lfirstass) if adist>.199 & adist<.201;
	egen Pip2=mean(lfirstass) if adist>.399 & adist<.401;
	egen Pip3=mean(lfirstass) if adist>.599 & adist<.601;
	egen Pip4=mean(lfirstass) if adist>.799 & adist<.801;
sort HHID;
replace Pip1=Pip1[_n-1] if Pip1==.;
replace Pip2=Pip2[_n-1] if Pip2==.;
replace Pip3=Pip3[_n-1] if Pip3==.;
replace Pip4=Pip4[_n-1] if Pip4==.;
gen omHHID=1-HHID;
sort omHHID;
replace Pip1=Pip1[_n-1] if Pip1==.;
replace Pip2=Pip2[_n-1] if Pip2==.;
replace Pip3=Pip3[_n-1] if Pip3==.;
replace Pip4=Pip4[_n-1] if Pip4==.;
sort HHID;
replace Pip1=Pip1[_n-1] if Pip1==.;
replace Pip2=Pip2[_n-1] if Pip2==.;
replace Pip3=Pip3[_n-1] if Pip3==.;
replace Pip4=Pip4[_n-1] if Pip4==.;
sum Pi*;
};

gen age=age1;



***************************************************************************;


* gen oopd=oop+drugc; * already defined, but something slightly different was apparently done;

* now make it household level;
gen medcosth=medcost;
replace medcosth=medcost + _medcost if married==1;
gen rmedcosth=rmedcost;
replace rmedcosth=rmedcost+_rmedcost if married==1;
sum medcosth rmedcosth;

gen ooph=oop;
replace ooph=oop +_oop if married==1;
gen drugch=drugc;
replace drugch=drugc+_drugc if married==1;
gen ipremh=iprem;
replace ipremh=iprem+_iprem if married==1;

* RAND DATA;
gen roopdh=roopd;
replace roopdh=roopd+_roopd if married==1;

gen medicaid_payh=medicaid_pay;
replace medicaid_payh=medicaid_pay+_medicaid_pay if married==1;



sort wave;
by wave: sum age1 dead medcost medcosth;


* household health care utilization;

gen nursingh=nursing;
replace nursingh=nursing + _nursing if married==1;
gen drtimesh=drtimes;
replace drtimesh=drtimes + _drtimes if married==1;
gen hosph=hosp;
replace hosph=hosp + _hosp if married==1;


*********************end of health cost recode **********************;

* decide what to do with estates--include as assets?;
replace assets=estate if (assets==. & estate~=. & includeestate==1);

sum assets;
* make a topcoding decision;
sum assets;
replace assets=maxass if assets>maxass & assets~=.;
sum assets;


******************************************;
* figure out if the man or woman ever died;
******************************************;

sort HHID wave;
/*
gen manw1=manmarstat if wave==1;
gen woman1=womanmarstat if wave==1;

replace manw1=manw1[_n-1] if HHID==HHID[_n-1] & wave>1;
replace woman1=woman1[_n-1] if HHID==HHID[_n-1] & wave>1;
*/
gen manw`firstwave'=manmarstat if wave==firstwave;
gen woman`firstwave'=womanmarstat if wave==firstwave;

replace manw`firstwave'=manw`firstwave'[_n-1] if HHID==HHID[_n-1] & wave>firstwave;
replace woman`firstwave'=woman`firstwave'[_n-1] if HHID==HHID[_n-1] & wave>firstwave;

/*
gen mandied=0;
replace mandied=1 if manmarstat==9 & (manw2~=9 & manw2~=0);
gen womandied=0;
replace womandied=1 if womanmarstat==9 & (woman2~=9 & woman2~=0);
*/
gen onedead=0;
replace onedead=1 if mandied==1|womandied==1;
gen alldead=0;
replace alldead=1 if (manmarstat==9 & (womanmarstat==9|womanmarstat==0))| (womanmarstat==9 & (manmarstat==9|manmarstat==0));


egen one=max(onedead), by(HHID);
egen all=max(alldead), by(HHID);

gen counter5=1;
replace counter5=counter5[_n-1]+1 if HHID==HHID[_n-1];
egen count5=sum(counter5) if counter5==1;
* end of drops;
* count1=> initial sample;
* count2=> drop younger than 65;
* count3=> unknown or changing marital status;
* count4=> drop workers;
* count5=> drop missing obs;
drop counter*;
sum count* one all ;


*******drop those with missing PI ********;
* this drops mostly those who are dead by wave 3 (ie, 1996);

drop if PI==.;

*summarize key variables for sample;
sum age age_wife hhmedcost_b hhmedicaid_pay assets hhnursing hhinc if hhstatus>0 &hhstatus!=.;

*save C:\Dropbox\hrs\wealthcouples\dataprep1, replace;
save C:\Users\ebf26\Dropbox\hrs\wealthcouples\dataprep1, replace;
drop _all;
program drop _all;
log close;
